<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User_group extends Model 
{

    protected $table = 'user_group';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function users()
    {
        return $this->hasMany('App\Models\Users', 'user_group_id');
    }

    public function group_system_part()
    {
        return $this->hasMany('App\Models\Group_system_part', 'user_group_id');
    }

    public function user_permission()
    {
        return $this->hasMany('App\Models\User_persmission', 'user_group_id');
    }

}